
 #!/bin/sh
 # the next line restarts using tclsh \
 exec tclsh "$0" "$@"

package require Gnocl

set table [gnocl::table -homogeneous 1]
$table addRow [list [gnocl::button -text "Exit" -onClicked exit] "" [gnocl::button -text "2"]]
$table addColumn [list [gnocl::button -text "3"] "" [gnocl::button -text "4"]]
$table add [gnocl::button -text "5"] 1 0 -rowSpan 3
$table add [gnocl::button \
	-text "Decorate" \
	-onClicked {
		if {[$win cget -decorated] == "1"} {
			$win configure -decorated 0
		} else {
			$win configure -decorated 1
		}
	} ] 2 1 -columnSpan 2

set win [gnocl::window \
	-onDelete exit \
	-borderWidth 1 \
	-title "Bitmask Test" \
	-defaultWidth 200 \
	-defaultHeight 200 \
	-backgroundImage EU_flag.jpg \
	-mask round200a.png \
	-opacity 0.85 \
	-decorated 0 \
	-keepAbove 1 \
	-child $table \
	-x 200 \
	-y 200 \
	]

set box2 [gnocl::box]

set img [gnocl::image -image "%/button_play1.png" ]
set lab [gnocl::label -text LABEL ]

set ebut [gnocl::eventBox \
	-backgroundImage button_play1_bg.png \
	-onButtonPress {puts "Play Button Pressed"} \
	-child $img \
	-width 150 \
	-height 75 \
	]


$box2 add $ebut -fill {0 0} -expand 1

set win2 [gnocl::window \
	-backgroundImage EU_flag.jpg \
	-onDelete exit \
	-backgroundColor cyan \
	-borderWidth 0 \
	-title "Round Button" \
	-child $box2 \
	-defaultWidth 200 \
	-defaultHeight 200 \
	-keepAbove 1 \
	-x 400 \
	-y 200 \
	]



gnocl::mainLoop
